<?php
error_reporting(1);
header("Access-Control-Allow-Origin: *"); 
header("Content-Security-Policy: Frame-Ancestors https://$_GET[shop] https://admin.shopify.com;");
header("X-Frame-Options: ALLOWALL");
header("X-XSS-Protection: 1; mode=block");
require 'vendor/autoload.php';
use GuzzleHttp\Client;
$dotenv = new Dotenv\Dotenv(__DIR__);
$dotenv->load();
$db = new Mysqli(getenv('MYSQL_HOST'), getenv('MYSQL_USER'), getenv('MYSQL_PASS'), getenv('MYSQL_DB'));
$api_key = getenv('SHOPIFY_APIKEY');
$secret_key = getenv('SHOPIFY_SECRET');
$app_base_url = getenv('APP_BASE_URL');
$api_version = getenv('API_VERSION');
$query = $_GET;
if (!isset($query['code'], $query['hmac'], $query['shop'], $query['state'], $query['timestamp'])) {
    exit;
}
$hmac = $query['hmac'];
unset($query['hmac']);
$params = [];
foreach ($query as $key => $val) {
    $params[] = "$key=$val";
}
asort($params);
$params = implode('&', $params);
$calculated_hmac = hash_hmac('sha256', $params, $secret_key);
$store = $query['shop'];
if ($hmac === $calculated_hmac) {
    $client = new Client();
    $response = $client->request(
        'POST', "https://{$store}/admin/oauth/access_token", [
            'form_params' => [
                'client_id' => $api_key,
                'client_secret' => $secret_key,
                'code' => $query['code']
            ]
        ]
    );
    $data = json_decode($response->getBody()->getContents(), true);
    $access_token = $data['access_token'];
    $db->query("UPDATE installs SET `access_token` = '$access_token'  WHERE `store` = '$store'");

    //====================getting the shop details=============================//
    $clientshop= new Client();
    $shopdata = $clientshop->request('GET','https://'.$store.'/admin/api/'.$api_version.'/shop.json', [
        'query' => [
            'access_token' => $access_token,
            'fields'=>'id,name,country_code,currency'
        ]
    ]);
    $get_shopdetails = json_decode($shopdata->getBody()->getContents(), true);
    $country_code = $get_shopdetails['shop']['country_code'];
    $currency = $get_shopdetails['shop']['currency'];

    /*************** Write scripts into theme.liquid file **************** */
    $clienttheme = new Client();
    $responsetheme = $clienttheme->request(
            'GET', "https://{$store}/admin/themes.json", [
        'query' => [
            'access_token' => $access_token
        ]
            ]
    );
    $gettheme = json_decode($responsetheme->getBody()->getContents(), true);
    $themeid = array();
    foreach ($gettheme as $getthemes) {
        $count_val2 = count($getthemes);

        for ($i = 0; $i < $count_val2; $i++) {
            $themerole = $getthemes[$i]['role'];
            if ($themerole == "main") {
                $themeid[] = $getthemes[$i]['id'];
            }
        }
    }
    $thmid = "";
    foreach ($themeid as $themeids) {
        $clientstabjs = new Client();
        $responsetabjs = $clientstabjs->request(
                'GET', "https://{$store}/admin/themes/{$themeids}/assets.json", [
            'query' => [
                'asset[key]' => 'layout/theme.liquid',
                'theme_id' => $themeids,
                'access_token' => $access_token
            ]
                ]
        );
        $getthemeindextabjs = json_decode($responsetabjs->getBody()->getContents(), true);
        
    }

/* end write scripts into theme.liquid file */
    // $clientnew = new Client();
    // $script_tag = [
    //     'script_tag' => [
    //         'src' => $app_base_url.'js/custom.js',
    //         'event' => 'onload',
    //         'display_scope' => 'online_store'
    //     ]
    // ];
    // $responsee = $clientnew->request('POST', 'https://' . $query['shop'] . '/admin/api/'.$api_version.'/script_tags.json', [
    //     'json' => $script_tag,
    //     'headers' => ['X-Shopify-Access-Token' => $access_token,'X-Shopify-Store-Name'=> $query['shop']]
    // ]);

    //   $clientneww = new Client();
    // $script_tag1 = [
    //     'script_tag' => [
    //         'src' => $app_base_url.'js/jquery.min.js',
    //         'event' => 'onload',
    //         'display_scope' => 'online_store'
    //     ]
    // ];
    // $responseew = $clientneww->request('POST', 'https://' . $query['shop'] . '/admin/api/'.$api_version.'/script_tags.json', [
    //     'json' => $script_tag1,
    //     'headers' => ['X-Shopify-Access-Token' => $access_token,'X-Shopify-Store-Name'=> $query['shop']]
    // ]);

    //   $clientnewww = new Client();
    // $script_tag12 = [
    //     'script_tag' => [
    //         'src' => $app_base_url.'js/jquery-ui.min.js',
    //         'event' => 'onload',
    //         'display_scope' => 'online_store'
    //     ]
    // ];
    // $responseeww = $clientnewww->request('POST', 'https://' . $query['shop'] . '/admin/api/'.$api_version.'/script_tags.json', [
    //     'json' => $script_tag12,
    //     'headers' => ['X-Shopify-Access-Token' => $access_token,'X-Shopify-Store-Name'=> $query['shop']]
    // ]);

    $sql2 = "SELECT * FROM trial_used WHERE shop ='$store'";
    $resultt = $db->query($sql2);
    $roww = mysqli_fetch_assoc($resultt);
    $storename = $roww['shop'];
    if ($storename) {
       $trial = "30";
    } else {
        $trial = "30";
    }
     $urls = "https://{$store}/admin/apps/{$api_key}/shopifyapp/esfera_review_app/basic_plan_selected.php?shop={$store}";

    $clientnew2 = new Client();
    $charge = [
        'recurring_application_charge' => [
            'name' => 'Basic Plan',
            'price' => 19.00,
            'test' => true,
            'return_url' => ''.$urls.'',
            "trial_days" => ''.$trial.''        
        ]
    ];

    $myresponsee = $clientnew2->request('POST', 'https://' . $query['shop'] . '/admin/api/'.$api_version.'/recurring_application_charges.json', [
        'json' => $charge,
        'headers' => ['X-Shopify-Access-Token' => $access_token]
    ]);

    $databilling = json_decode($myresponsee->getBody()->getContents(), true);

    $billingapi = $databilling['recurring_application_charge']['confirmation_url'];
    $billing_Id = $databilling['recurring_application_charge']['id'];
    $api_client_id = $databilling['recurring_application_charge']['api_client_id'];
    $createdd = $databilling['recurring_application_charge']['created_at'];
    $actstatus = $databilling['recurring_application_charge']['status'];
    $created = explode("T", $createdd);
    $billdate = $created[0];
    
    if ($storename) {
    $update = $db->query("UPDATE trial_used SET trial = '0' WHERE shop = '$store'");    
    }else{
    $db->query("INSERT into `trial_used` (shop,trial) VALUES ('".$store."','".$trial."')"); 
    }

    //********* when app uninstalled ***********//
    $clientnew3 = new Client();
    $webhook = [
        'webhook' => [
            'topic' => 'app/uninstalled',
            'address' => $app_base_url.'m-uninstall.php',
            'format' => 'json'
        ]
    ];
    $myresponsee3 = $clientnew3->request('POST', 'https://' . $query['shop'] . '/admin/api/'.$api_version.'/webhooks.json', [
        'json' => $webhook,
        'headers' => ['X-Shopify-Access-Token' => $access_token]
    ]);
    
    $nonce = $query['state'];

    if ($select = $db->prepare("SELECT id FROM installs WHERE store = ?")) {
        $select->bind_param('s', $store);
        $select->execute();
        $select->bind_result($id);
        $select->fetch();
        $select->close();
        $db->query("UPDATE installs SET access_token = '$access_token', status_activation = '$actstatus' , recurring_id = '$billing_Id', client_id = '$api_client_id', install_date = '$billdate'  WHERE id = '$id'");
        header("Location: {$billingapi}");
    }  
}