<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header("Access-Control-Allow-Origin: *"); 
header("Content-Security-Policy: Frame-Ancestors https://$_GET[shop] https://admin.shopify.com;");
header("X-Frame-Options: ALLOWALL");
header("X-XSS-Protection: 1; mode=block");
require 'vendor/autoload.php';
use GuzzleHttp\Client;
$dotenv = new Dotenv\Dotenv(__DIR__);
$dotenv->load();
$db = new Mysqli(getenv('MYSQL_HOST'), getenv('MYSQL_USER'), getenv('MYSQL_PASS'), getenv('MYSQL_DB'));
$store = $_GET['shop'];
$factory = new RandomLib\Factory;
$generator = $factory->getMediumStrengthGenerator();
$nonce = $generator->generateString(20);
$api_key = getenv('SHOPIFY_APIKEY');
$scopes = getenv('SHOPIFY_SCOPES');
$app_base_url = getenv('APP_BASE_URL');
$api_version = getenv('API_VERSION');
$redirect_uri = urlencode(getenv('SHOPIFY_REDIRECT_URI'));
$sql = "SELECT * FROM installs WHERE store ='$store'";
$result = $db->query($sql);
$row = mysqli_fetch_assoc($result);
$lastid = $row['id'];
$storename = $row['store'];
$recurring_id = $row['recurring_id'];
$client_id = $row['client_id'];
if(($client_id === NULL) && ($recurring_id === NULL)){
    $delete = "Delete FROM `installs` WHERE `store`='$storename'";
    $db->query($delete);
}
if (($storename) && ($recurring_id !== NULL)){
    $select2 = $db->query("SELECT access_token,recurring_id FROM installs WHERE store = '$store'");
    $user2 = $select2->fetch_object();
    $access_token = $user2->access_token;
    $billing_Id = $user2->recurring_id;
    //=================for getting shop details=======================//
    $clientshop= new Client();
    $shopdata = $clientshop->request('GET','https://'.$store.'/admin/api/'.$api_version.'/shop.json', [
        'query' => [
            'access_token' => $access_token,
            'fields'=>'id,name,country_code,currency'
        ]
    ]);
    $get_shopdetails = json_decode($shopdata->getBody()->getContents(), true);
    $country_code = $get_shopdetails['shop']['country_code'];
    $currency = $get_shopdetails['shop']['currency'];
    if (empty($billing_Id)){
        $rurls = "https://{$store}/admin/apps/{$api_key}/shopifyapp/esfera_review_app/charge_declined.php?shop={$store}";
        echo '<script type="text/javascript">window.top.location.href = "' . $rurls . '"; </script>';
    } 
    $clientgetstatus = new Client();
    $billstatus = $clientgetstatus->request('GET', 'https://' . $store . '/admin/api/'.$api_version.'/recurring_application_charges/'.$billing_Id.'.json', [
        'headers' => ['X-Shopify-Access-Token' => $access_token]
    ]);
    $get_billstatus = json_decode($billstatus->getBody()->getContents(), true);
    $bill_status = $get_billstatus['recurring_application_charge']['status'];
    echo 'You are been automatically redirected...';
    if ($bill_status == "pending" || $bill_status == "declined") {
        $sql2 = "SELECT * FROM trial_used WHERE shop ='$store'";
        $resultt = $db->query($sql2);
        $roww = mysqli_fetch_assoc($resultt);
        $storename = $roww['shop'];
        if ($storename) {
         $trial = "7";
     } else {
        $trial = "7";
    }
    $urls = "https://{$store}/admin/apps/{$api_key}/shopifyapp/esfera_review_app/basic_plan_selected.php?shop={$store}";
    $clientnew2 = new Client();
    $charge = [
        'recurring_application_charge' => [
            'name' => 'Basic Plan',
            'price' => 19.00,
             'test' => true,
            'return_url' => '' . $urls . '',
            "trial_days" => '' . $trial . ''
        ]
    ];
    $myresponsee = $clientnew2->request('POST', 'https://'.$store.'/admin/api/'.$api_version.'/recurring_application_charges.json', [
        'json' => $charge,
        'headers' => ['X-Shopify-Access-Token' => $access_token]
    ]);
    $databilling = json_decode($myresponsee->getBody()->getContents(), true);
    $billingapi = $databilling['recurring_application_charge']['confirmation_url'];
    $billing_Id = $databilling['recurring_application_charge']['id'];
    $api_client_id = $databilling['recurring_application_charge']['api_client_id'];
    $createdd = $databilling['recurring_application_charge']['created_at'];
    $actstatus = $databilling['recurring_application_charge']['status'];
    $created = explode("T", $createdd);
    $billdate = $created[0];
    $db->query("UPDATE installs SET app_enabled = 'disable',status_activation = '$actstatus' , recurring_id = '$billing_Id', client_id = '$api_client_id', install_date = '$billdate' WHERE store = '$store'");
    echo '<script type="text/javascript">window.top.location.href = "' . $billingapi . '"; </script>';
}else{
    echo '<script type="text/javascript">window.top.location.href = "https://' . $_GET['shop'] . '/admin/apps/' . $api_key . '/shopifyapp/esfera_review_app/main.php?shop=' . $_GET['shop'] . '"; </script>';
}
}else{
    if ($query = $db->prepare('INSERT INTO installs SET store = ?, nonce = ?, access_token = ""')) {
        $query->bind_param('ss', $store, $nonce);
        $query->execute();
        $query->close();
        $url = "https://{$store}/admin/oauth/authorize?client_id={$api_key}&scope={$scopes}&redirect_uri={$redirect_uri}&state={$nonce}";
        header("Location: {$url}");
    }
}