<?php
error_reporting(1);
header("Access-Control-Allow-Origin: *"); 
header("Content-Security-Policy: Frame-Ancestors https://$_GET[shop] https://admin.shopify.com;");
header("X-Frame-Options: ALLOWALL");
header("X-XSS-Protection: 1; mode=block");
require 'vendor/autoload.php';
use GuzzleHttp\Client;
$dotenv = new Dotenv\Dotenv(__DIR__);
$dotenv->load();
$db = new Mysqli(getenv('MYSQL_HOST'), getenv('MYSQL_USER'), getenv('MYSQL_PASS'), getenv('MYSQL_DB')); 
$secret_key = getenv('SHOPIFY_SECRET');
$api_key = getenv('SHOPIFY_APIKEY');
$app_base_url = getenv('APP_BASE_URL');
function verify_webhook($webhook_payload, $hmac_header)
{
  $calculated_hmac = base64_encode(hash_hmac('sha256', $webhook_payload, $secret_key, true));
  return hash_equals($hmac_header, $calculated_hmac);
}
echo $hmac_header = $_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'];
$webhook_payload = file_get_contents('php://input');
$verified = verify_webhook($webhook_payload, $hmac_header);
$webhook_payload_obj = json_decode($webhook_payload, true);
$shop_id = $webhook_payload_obj['shop_id'];
$domain_shop = $webhook_payload_obj['shop_domain'];
$cID = $webhook_payload_obj['customer']['id'];
$eEmail = $webhook_payload_obj['customer']['email'];
$getdetail = "SELECT * from installs WHERE store ='".$domain_shop."'";
$result = $db->query($getdetail);
$row = mysqli_fetch_assoc($result);
$access_token = $row["access_token"];
$client = new Client();
$response = $client->request(
    'GET', "https://{$domain_shop}/admin/api/2019-10/shop.json", [
    'query' => [
        'access_token' => $access_token
    	]
    ]
);
$getshopdetails = json_decode($response->getBody()->getContents(), true);
$storename = $getshopdetails['shop']['name'];
$storeemail = $getshopdetails['shop']['email'];
$getcustomer = "SELECT * from store_information WHERE store ='".$domain_shop."'";
$result1 = $db->query($getcustomer);
$row1 = mysqli_fetch_assoc($result1);
$customer_email = $row1["customer_email"];
$domainid = $row1["domainid"];
if (!empty($row1)) {
	$htmldata = '<p>Hello '.$storename.',</p>
			<br><br>
			<p>Please find the data of customer (<i>Email - '.$customer_email.'</i>) that you had requested.</p>
			<br>
			<p><b>Customer Email:</b> '.$customer_email.'</p>
			<p><b>Customer Domain Id No:</b> '.$domainid.'</p>
			<br><br>
			<p>We have use only mentioned data in our Salonist Shopify app.</p>
			<br>
			<p>Thanks & Regards</p>
			<p>Smart Review TEAM.</p>';

			// Always set content-type when sending HTML email
$headers = "MIME-Version: 1.0" . "\r\n";
$to = $customer_email;
$subject = "Smart Review - Customer Data Request";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

// More headers
$headers .= 'From: Smart Review <jonu89@gmail.com>' . "\r\n";

mail($to,$subject,$htmldata,$headers);
return http_response_code(200);
}
else{
	$htmldata = '<p>Hello '.$storename.',</p>
				<br><br>
				<p>The data of the customer (<i>Email - '.$customer_email.'</i>) that you had requested, is not founded in our system.</p>
				<br>
				<br>
				<p>Thanks & Regards</p>
				<p>Smart Review TEAM.</p>';
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
$to = $customer_email;
$subject = "Smart Review - Customer Data Request";

// More headers
$headers .= 'From: Smart Review <jonu89@gmail.com>' . "\r\n";

mail($to,$subject,$htmldata,$headers);
return http_response_code(200);
}
?>