<?php
$input = file_get_contents("php://input");
file_put_contents("test.txt", $input);
$rates = json_decode($input, true);

$quantity = 0;
$items = [];
$priceitem = "";
$priceitems = 0;

foreach ($rates["rate"]["items"] as $key => $item) {
    $priceitem = $item["price"] * $item["quantity"];
    $priceitems = $priceitems + $priceitem;
}

$priceitems;

$rates = [];
$pr = $priceitems;
$percentage = "2.5";

$output = ["rates" => $rates];
// overnight shipping is 5.50 per item
$overnight_cost = $pr - $pr * ($percentage / 100);
$final_discount = $pr - $overnight_cost;

// overnight shipping is 1 to 2 days after today
$on_min_date = date("Y-m-d H:i:s O", strtotime("+1 day"));
$on_max_date = date("Y-m-d H:i:s O", strtotime("+2 days"));

// build the array of line items using the prior values
$output = [
    "rates" => [
        [
            "service_name" => "Processing charges",
            "service_code" => "FSTD",
            "total_price" => $final_discount,
            "description" => "This is the Processing charges",
            "currency" => "USD",
            "min_delivery_date" => $on_min_date,
            "max_delivery_date" => $on_max_date,
        ],
    ],
];

// encode into a json response
$json_output = json_encode($output);

// log it so we can debug the response
file_put_contents($filename . "-output", $json_output);

// send it back to shopify
header("Content-Type: application/json");
echo $json_output;
//        return $json_output;
?>
