<?php
	$post_thumb_class = 'no-post-thumb';
	if (has_post_thumbnail()) :
		$post_thumb_class = '';
	endif;
	$is_sticky_class = '';
	if (is_sticky()) :
		$is_sticky_class = 'sticky-post-class';
	endif;
	$the_title_content = get_the_title();
	$the_title_class_have = 'have-title-post';
	if( $the_title_content != '') :
		$the_title_class_have = '';
	endif;
?>

<div class="news-block-one <?php echo esc_attr( $the_title_class_have . ' ' . $post_thumb_class . ' ' . $is_sticky_class); ?>">
	<?php
		if (is_sticky()) {
			echo '<div class="sticky_post_icon " title="' . esc_attr__('Sticky Post', 'visarzo') . '"><i class="fas fa-map-pin"></i></div>';
		}
	?>
	<div class="inner-box">
		<?php if (has_post_thumbnail()) : ?>
			<figure class="image-box">
				<?php visarzo_post_thumbnail(); ?>
			</figure>
		<?php endif; ?>
		<div class="lower-content">
			<div class="post-date"><h5><?php visarzo_posted_on(); ?></h5></div>
			<?php
				if (is_singular()) :
					the_title('<h2 class="entry-title">', '</h2>');
				else :
					the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');
				endif;
			?>
			<ul class="post-info clearfix">
				<li><?php visarzo_posted_by(); ?></li>
				<li><?php visarzo_category_list(); ?></li>
				<li><?php visarzo_comments_count(); ?></li>
			</ul>
			<?php if( !empty(get_the_excerpt()) ) : ?>
				<?php
					if (get_option('rss_use_excerpt')) {
						the_excerpt();
					} else {
						the_excerpt();
					}
				?>
			<?php endif; ?>
			<?php
				wp_link_pages(array(
					'before' => '<div class="page-links">',
					'after' => '</div>',
				));
			?>
			<div class="link"><a href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read More','visarzo');?><i class="flaticon-send"></i></a></div>
		</div>
	</div>
</div>