<?php
get_header();
$prefix                          = 'visarzo_theme_metabox';
$visarzo_service_post_id         = get_the_ID();
$visarzo_single_service_subtitle = get_post_meta( $visarzo_service_post_id, "{$prefix}_sub_title", true );
$visarzo_single_service_content  = get_post_meta( $visarzo_service_post_id, "{$prefix}_content", true );

$visarzo_theme_metabox_single_service_image = get_post_meta( get_queried_object_id(), 'visarzo_theme_metabox_single_service_image', true );
$visarzo_service_images                     = wp_get_attachment_image_src( $visarzo_theme_metabox_single_service_image, 'full' );


?>
<div class="sidebar-page-container">
	<div class="auto-container">
		<div class="row clearfix">
			<div class="col-lg-4 col-md-12 col-sm-12 sidebar-side">
				<div class="sidebar">
					<?php dynamic_sidebar( 'sidebar-2' ); ?>
				</div>
			</div>
			<div class="col-lg-8 col-md-12 col-sm-12 content-side">
				<div class="coaching-details-content service-details-content">
					<div class="content-style-one">
						<figure class="image-box"><img src="<?php echo esc_url( $visarzo_service_images[0] ); ?>" alt="<?php esc_attr_e( 'feature image', 'visarzo' ); ?>"></figure>
						<div class="group-title">
							<h2><?php the_title(); ?></h2>
							<div class="dotted-box">
								<span class="dotted"></span>
								<span class="dotted"></span>
								<span class="dotted"></span>
							</div>
						</div>
						<div class="text">
							<h3><?php echo wp_kses( $visarzo_single_service_subtitle, 'code_contxt' ); ?></h3>
							<p><?php echo wp_kses( $visarzo_single_service_content, 'code_contxt' ); ?></p>
						</div>
					</div>
					<?php
					while ( have_posts() ) :
						the_post();
						the_content();
					endwhile; // End of the loop.
					?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php
get_footer();
