<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package visarzo
 */

get_header();
?>
<!--Sidebar Page Container-->
<section class="error-section centred">
	<div class="container">
		<div class="content-box">
			<h1><?php esc_html_e('404', 'visarzo'); ?></h1>
			<h2><?php esc_html_e('Oops! That page can not be found.', 'visarzo'); ?></h2>
			<div class="text">
				<?php
					$mega_text_four_o_four = 'Can not find what you need? Take a moment and do a search <br> below or start from our <a href="' .  esc_url(home_url('/')) .'">Homepage.</a>';
					echo wp_kses($mega_text_four_o_four,'code_contxt');
				?>
			</div>
		</div>
	</div>
</section>
<?php
get_footer();
